/******************************************************************************
* Version 2.0.2 (September 15 2006)
*
* Author: Torstein Hnsi
* Email: See www.vikjavev.no/megsjol
*
* This script is free for non-commersial use, but leave this header.
*
******************************************************************************/
/*****************************************************************************
* Edited By Sami (BMossavari at gmail dot com) For Coppermine compatibility 
* Edit: "cpghs_" added to all global variables and functions
******************************************************************************/



var hs = {

// Apply your own settings here, or override them in the html file.  
cpghs_graphicsDir : 'highslide/graphics/',
cpghs_restoreCursor : "zoomout.cur", // necessary for preload
cpghs_fullExpandIcon : 'fullexpand.gif',
cpghs_showCredits : false, // you can set this to false if you want
cpghs_expandSteps : 10, // number of steps in zoom. Each step lasts for duration/step milliseconds.
cpghs_expandDuration : 250, // milliseconds.
cpghs_restoreSteps : 10,
cpghs_restoreDuration : 250,
cpghs_numberOfImagesToPreload : 5, // set to 0 for no preload
cpghs_marginLeft : 10,
cpghs_marginRight : 35, // leave room for scrollbars + outline
cpghs_marginTop : 10,
cpghs_marginBottom : 35, // leave room for scrollbars + outline
cpghs_zIndexCounter : 1001, // adjust to other absolutely positioned elements
cpghs_fullExpandDelay : 500, // delay of the 'full expand'-icon
cpghs_fullExpandTitle : 'Expand to actual size',
cpghs_restoreTitle : 'Click to restore thumbnail',
cpghs_focusTitle : 'Click to bring to front',
cpghs_loadingText : 'Loading...',
cpghs_loadingTitle : 'Click to cancel',
cpghs_creditsText : 'Coppermine Gallery',
cpghs_creditsHref : 'http://coppermine-gallery.net',
cpghs_creditsTitle : 'Go to the Coppermine project homepage',

// These settings can also be overridden inline for each image
cpghs_anchor : 'auto', // where the image expands from
cpghs_spaceForCaption : 30, // leaves space below images with captions
cpghs_outlineType : 'drop-shadow', // set null to disable outlines
cpghs_wrapperClassName : null, // for enhanced css-control
// END OF YOUR SETTINGS


// declare internal properties
cpghs_preloadTheseImages : new Array(),
cpghs_continuePreloading: true,
cpghs_expandedImagesCounter : 0,
cpghs_expanders : new Array(),
cpghs_mouseIsOverFullExpand : false,
cpghs_isBusy : false,
cpghs_container : null,
cpghs_defaultRestoreCursor : null,
cpghs_leftBeforeDrag : null,
cpghs_topBeforeDrag : null,

// drag functionality
cpghs_ie : document.all,
cpghs_nn6 : document.getElementById && !document.all,
cpghs_hasFocused : false,
cpghs_isDrag : false,
cpghs_dragX : null,
cpghs_dragY : null,
cpghs_dragObj : null,

    

cpghs_ieVersion : function () {
    arr = navigator.appVersion.split("MSIE");
    return parseFloat(arr[1]);
},

//--- Find client width and height
cpghs_clientInfo : function ()	{
	var iebody = (document.compatMode && document.compatMode != "BackCompat") 
        ? document.documentElement : document.body;
    this.width = document.all ? iebody.clientWidth : self.innerWidth;
    this.height = document.all ? iebody.clientHeight : self.innerHeight;
	this.scrollLeft = document.all ? iebody.scrollLeft : pageXOffset;
	this.scrollTop = document.all ? iebody.scrollTop : pageYOffset;
} ,

//--- Finds the position of an element
cpghs_position : function(el)	{ 
	var pos = new Array(2);
	var parent = el;
	pos['x'] = parent.offsetLeft;
	pos['y'] = parent.offsetTop;
	// loop outh through parent elements:
	while (parent.offsetParent)	{
		parent = parent.offsetParent;
		pos['x'] += parent.offsetLeft;
		pos['y'] += parent.offsetTop;
	}
    
	return pos;
}, 

//--- Expander object keeps track of all properties
cpghs_expander : function() { },


//--- Do the thing
/* params can be one of: anchor, wrapperClassName, outlineType, spaceForCaption, thumbnailId */
cpghs_expand : function(a, params) {
	//    if (hs.cpghs_isBusy) return;
    hs.cpghs_isBusy = true;
    try {
        hs.cpghs_continuePreloading = false;
        hs.cpghs_container = document.getElementById('highslide-container');
        
        if (params && params.thumbnailId) {
            var el = document.getElementById(params.thumbnailId);
        
        } else { // first img within anchor
            for (i = 0; i < a.childNodes.length; i++) {
				if (a.childNodes[i].tagName && a.childNodes[i].tagName == 'IMG') {
                    var el = a.childNodes[i];
                    break;
                }    		
            }
        }
		
		// cancel other instances
        for (var i in hs.cpghs_expanders) {
            if (hs.cpghs_expanders[i] && hs.cpghs_expanders[i].thumb != el && !hs.cpghs_expanders[i].showFullImageStarted) {
                hs.cpghs_cancelLoading(i);
            }
        }
		
        
        // check if already open
        for (var i in hs.cpghs_expanders) {
            if (hs.cpghs_expanders[i] && hs.cpghs_expanders[i].thumb == el) {
                hs.cpghs_isBusy = false;
                return false;
            }
        }
        
        // initialize the new Expander object
        var key = hs.cpghs_expandedImagesCounter++;
        hs.cpghs_expanders[key] = new hs.cpghs_expander();
        var exp = hs.cpghs_expanders[key];
        exp.a = a;
		
		// override inline parameters
		var legalParams = new Array('cpghs_anchor', 'cpghs_outlineType', 'cpghs_spaceForCaption', 'cpghs_wrapperClassName');
		for (var i in legalParams) {
			var name = legalParams[i];
			if (params && params[name]) exp[name] = params[name];
			else exp[name] = hs[name];
		}
		
        
        var imgId = 'expanded-'+ hs.cpghs_expandedImagesCounter;
        exp.thumbsUserSetId = el.id;
        if (!el.id) el.id = 'hs-thumb-'+ hs.cpghs_expandedImagesCounter;
        exp.thumb = el;
        
        exp.originalCursor = el.style.cursor;
        el.style.cursor = 'wait';

        var pos = hs.cpghs_position(el);  
                
        // instanciate the wrapper
        var wrapper = document.createElement('div');
        wrapper.style.visibility = 'hidden';
        wrapper.style.position = 'absolute';
		if (exp.cpghs_wrapperClassName) wrapper.className = exp.cpghs_wrapperClassName;
        wrapper.style.zIndex = hs.cpghs_zIndexCounter++;        
        exp.wrapper = wrapper;
        
        // store properties of the thumbnail
        exp.thumbWidth = el.width;
        exp.thumbHeight = el.height;
        exp.thumbLeft = pos['x'];
        exp.thumbTop = pos['y'];
        
        // thumb borders
        exp.thumbOffsetBorderW = (exp.thumb.offsetWidth - exp.thumbWidth) / 2;
        exp.thumbOffsetBorderH = (exp.thumb.offsetHeight - exp.thumbHeight) / 2;
		
		// loading symbol
		var loading = document.createElement('a');
		loading.style.position = 'absolute';
		loading.style.visibility = 'hidden';
		loading.className = 'highslide-loading';
        loading.title = hs.cpghs_loadingTitle;
        loading.href = 'javascript:hs.cpghs_cancelLoading('+ key +')'
		hs.cpghs_container.appendChild(loading);
		if (hs.cpghs_loadingText) loading.innerHTML = hs.cpghs_loadingText;
        loading.style.left = (exp.thumbLeft + exp.thumbOffsetBorderW + (exp.thumbWidth - loading.offsetWidth) / 2) +'px';
		loading.style.top = (exp.thumbTop + (exp.thumbHeight - loading.offsetHeight) / 2) +'px';
		exp.loading = loading;
    	setTimeout("if (hs.cpghs_expanders["+ key +"].loading) hs.cpghs_expanders["+ key +"].loading.style.visibility = 'visible';", 100);
		
        // instanciate the full-size image
        var img = document.createElement('img');
        exp.fullImage = img;
        if (navigator.userAgent.indexOf("Safari") != -1) { // http://bugzilla.opendarwin.org/show_bug.cgi?id=3869
            img.onload = function () { 
                var safImg = new Image;
                safImg.src = this.src;
                exp.fullImage.width = safImg.width;
                exp.fullImage.height = safImg.height;
                hs.cpghs_showFullImage(key); 
            }
        } else {
            img.onload = function () { hs.cpghs_showFullImage(key); }
        }
        img.src = a.href;
        img.className = 'highslide-image '+ el.className;
        img.style.visibility = 'hidden' // prevent flickering in IE
        img.style.display = 'block';
		img.style.position = 'relative';
    	img.style.zIndex = 3;
		img.id = imgId;
        img.title = hs.cpghs_restoreTitle;
        img.onmouseover = function () { setTimeout("hs.cpghs_showFullExpand('"+ key +"')", hs.cpghs_fullExpandDelay); }
        img.onmouseout = function () { setTimeout("hs.cpghs_hideFullExpand('"+ key +"')", 50); }
        img.setAttribute('key', key); // used on drag


        return false; // important!
    
    } catch (e) {
        return true; // script failed: default href fires
    }
    
}, 

//--- Show the image after it has been preloaded
cpghs_showFullImage : function(key) {
	
	try { 
	    var exp = hs.cpghs_expanders[key];
	    
	    // prevent looping on certain Gecko engines:
	    if (exp.showFullImageStarted) return;
	    else exp.showFullImageStarted = true;
        
        // Iframes bug
        hs.hideIframes = (window.opera || navigator.vendor == 'KDE' || (hs.cpghs_ie && hs.cpghs_ieVersion() < 5.5));
        if (hs.hideIframes) hs.cpghs_toggleIFrames('hidden');
		
		// remove loading div
	    if (exp.loading) {
	        hs.cpghs_container.removeChild(exp.loading);
	        exp.loading = null;
	    }    
	    
	    exp.thumb.style.cursor = exp.originalCursor;
	    
        var newWidth = exp.fullImage.width; // causes problems in Safari
	    var newHeight = exp.fullImage.height;
	    exp.fullExpandWidth = newWidth;
	    exp.fullExpandHeight = newHeight;
	    
	    exp.fullImage.width = exp.thumb.width;
	    exp.fullImage.height = exp.thumb.height;
	
	    // identify caption div
	    var modMarginBottom = hs.cpghs_marginBottom;
	    var thumbsUserSetId = exp.thumbsUserSetId; // id has to be user set
	    if (thumbsUserSetId && document.getElementById('caption-for-'+ thumbsUserSetId)) {
	        var captionClone = document.getElementById('caption-for-'+ exp.thumb.id).cloneNode(true);
	        exp.caption = captionClone;
	        modMarginBottom += exp.cpghs_spaceForCaption;
	    }
        
	    
	    exp.wrapper.appendChild(exp.fullImage)
	    exp.wrapper.style.left = exp.thumbLeft;
	    exp.wrapper.style.top = exp.thumbTop;
	    hs.cpghs_container.appendChild(exp.wrapper);
		
		// correct for borders
	    exp.offsetBorderW = (exp.wrapper.offsetWidth - exp.thumb.width) / 2;
        exp.offsetBorderH = (exp.wrapper.offsetHeight - exp.thumb.height) / 2;
	    var modMarginRight = hs.cpghs_marginRight + 2 * exp.offsetBorderW;
        modMarginBottom += 2 * exp.offsetBorderH;
	    
	    var ratio = newWidth / newHeight;
	    
	    // default (start) values
		var newLeft = parseInt(exp.thumbLeft) - exp.offsetBorderW + exp.thumbOffsetBorderW;
	    var newTop = parseInt(exp.thumbTop) - exp.offsetBorderH + exp.thumbOffsetBorderH;
	    var oldRight = newLeft + parseInt(exp.thumb.width);
	    var oldBottom = newTop + parseInt(exp.thumb.height);
	    
	    var justifyX;
	    var justifyY;
	    switch (exp.cpghs_anchor) {
	    case 'auto':
	        justifyX = 'auto';
	        justifyY = 'auto';
	        break;
	    case 'top':
	        justifyX = 'auto';
	        break;
	    case 'top-right':
	        justifyX = 'right';
	        break;
	    case 'right':
	        justifyX = 'right';
	        justifyY = 'auto';
	        break;
	    case 'bottom-right':
	        justifyX = 'right';
	        justifyY = 'bottom';
	        break;
	    case 'bottom':
	        justifyX = 'auto';
	        justifyY = 'bottom';
	        break;
	    case 'bottom-left':
	        justifyY = 'bottom';
	        break;
	    case 'left':
	        justifyY = 'auto';
	        break;
	    case 'top-left':
	        break;
	    default:
	        justifyX = 'auto';
	        justifyY = 'auto';        
	    } 
	    
	    var client = new hs.cpghs_clientInfo();
	    
	    
	    if (justifyX == 'auto') {
	        var hasMovedNewLeft = false;
	        // calculate newLeft
	        newLeft = Math.round(newLeft - ((newWidth - exp.thumb.width) / 2)); // as in center
	        if (newLeft < client.scrollLeft + hs.cpghs_marginLeft) {
	            newLeft = client.scrollLeft + hs.cpghs_marginLeft;
	            hasMovedNewLeft = true;
	        }
	        // calculate right/newWidth
	        if (newLeft + newWidth > client.scrollLeft + client.width - hs.cpghs_marginLeft) {
	            if (hasMovedNewLeft) newWidth = client.width - hs.cpghs_marginLeft - modMarginRight; // can't expand more
	            else if (newWidth < client.width - hs.cpghs_marginLeft - modMarginRight) { // move newTop up
	                newLeft = client.scrollLeft + client.width - newWidth - hs.cpghs_marginLeft - modMarginRight;
	            } else { // image larger than client
	                newLeft = client.scrollLeft + hs.cpghs_marginLeft;
	                newWidth = client.width - hs.cpghs_marginLeft - modMarginRight;
	            }
	        }
	    } else if (justifyX == 'right') {
	        newLeft = Math.floor(newLeft - newWidth + exp.thumb.width);
	    }
	    if (justifyY == 'auto') {
	        var hasMovedNewTop = false;
	        // calculate newTop
	        newTop = Math.round(newTop - ((newHeight - exp.thumb.height) / 2)); // as in center
	        if (newTop < client.scrollTop + hs.cpghs_marginTop) {
	            newTop = client.scrollTop + hs.cpghs_marginTop;
	            hasMovedNewTop = true;
	        }
	        // calculate bottom/newHeight
	        if (newTop + newHeight > client.scrollTop + client.height - hs.cpghs_marginTop - modMarginBottom) {
	            if (hasMovedNewTop) newHeight = client.height - hs.cpghs_marginTop - modMarginBottom; // can't expand more
	            else if (newHeight < client.height - hs.cpghs_marginTop - modMarginBottom) { // move newTop up
	                newTop = client.scrollTop + client.height - newHeight - hs.cpghs_marginTop - modMarginBottom;
	            } else { // image larger than client
	                newTop = client.scrollTop + hs.cpghs_marginTop;
	                newHeight = client.height - hs.cpghs_marginTop - modMarginBottom;
	            }
	        }
	    } else if (justifyY == 'bottom') {
	        newTop = Math.floor(newTop - newHeight + exp.thumb.height);
	    }
	    
	    // don't leave the page; better to expand right bottom
	    if (newLeft < hs.cpghs_marginLeft) {
	        tmpLeft = newLeft;
	        newLeft = hs.cpghs_marginLeft; 
	        newWidth = newWidth - (newLeft - tmpLeft);
	    }
	    if (newTop < hs.cpghs_marginTop) {
	        tmpTop = newTop;
	        newTop = hs.cpghs_marginTop;
	        newHeight = newHeight - (newTop - tmpTop);
	    }
	
	    // Correct ratio
	    if (newWidth / newHeight > ratio) { // width greater
	        var tmpWidth = newWidth;
	        newWidth = newHeight * ratio;
	        if (justifyX == 'center' || justifyX == 'auto') {
	            // recalculate newLeft
	            newLeft = Math.round(parseInt(exp.thumbLeft) 
	                - ((newWidth - exp.thumb.width) / 2));
	            if (newLeft < client.scrollLeft + hs.cpghs_marginLeft) { // to the left
	                newLeft = client.scrollLeft + hs.cpghs_marginLeft;
	            } else if (newLeft + newWidth > client.scrollLeft + client.width - modMarginRight) { // to the right
	                newLeft = client.scrollLeft + client.width - newWidth - modMarginRight;
	            }
	        }
	        if (justifyX == 'right') newLeft = newLeft + (tmpWidth - newWidth);
	    
	    } else if (newWidth / newHeight < ratio) { // height greater
	        var tmpHeight = newHeight;
	        newHeight = newWidth / ratio;
	        if (justifyY == 'center' || justifyY == 'auto') {
	            // recalculate newTop
	            newTop = Math.round(parseInt(exp.thumbTop) 
	                - ((newHeight - exp.thumb.height) / 2));
	            if (newTop < client.scrollTop + hs.cpghs_marginTop) { // above
	                newTop = client.scrollTop + hs.cpghs_marginTop;
	            } else if (newTop + newHeight > client.scrollTop + client.height - modMarginBottom) { // below
	                newTop = client.scrollTop + client.height - newHeight - modMarginBottom;
	            }
	        }
	        if (justifyY == 'bottom') newTop = newTop + (tmpHeight - newHeight);
	    }
	    
	        
	    
	    // Apply size change
	    var width = exp.thumb.width;
	    var height = exp.thumb.height;
		var left = exp.thumbLeft + exp.thumbOffsetBorderW - exp.offsetBorderW;
	    var top = exp.thumbTop + exp.thumbOffsetBorderH - exp.offsetBorderH;
		intervalWidth = (newWidth - width) / hs.cpghs_expandSteps;
		intervalHeight = (newHeight - height) / hs.cpghs_expandSteps;
	    intervalLeft = (newLeft - left) / hs.cpghs_expandSteps;
	    intervalTop = (newTop - top) / hs.cpghs_expandSteps;
	    
	    for (i = 1; i < hs.cpghs_expandSteps; i++) {
			width += intervalWidth;
			height += intervalHeight;
	        left += intervalLeft;
	        top += intervalTop;
	        if (justifyX == 'right') { // follow the edge nicely
	            width = Math.round(width);
	            left = oldRight - width;
	        }
	        if (justifyY == 'bottom') { 
	            height = Math.round(height);
	            top = oldBottom - height;
	        }
	        
			setTimeout("hs.cpghs_changeSize("+ key +", "+ width +", "+ height +", "+ left +", "+ top +")", 
	            Math.round(i * (hs.cpghs_expandDuration / hs.cpghs_expandSteps)));
		}
	    
	    // setTimeout("hs.changeClassName("+ key +")", hs.cpghs_expandDuration/2);    
		// Finally land on the right number:
		setTimeout("hs.cpghs_changeSize("+ key +", "+ newWidth +", "+ newHeight +", "+ newLeft 
	        +", "+ newTop +")", hs.cpghs_expandDuration);
		setTimeout("hs.cpghs_focus("+ key +")", hs.cpghs_expandDuration);
        if (hs.cpghs_showCredits) setTimeout("hs.cpghs_writeCredits("+ key +")", hs.cpghs_expandDuration + 25);
	    if (exp.caption) {
	        setTimeout("hs.cpghs_writeCaption("+ key +")", hs.cpghs_expandDuration + 50);
	    } else {
			setTimeout( "hs.cpghs_writeOutline("+ key +")", hs.cpghs_expandDuration + 50);
	    }
		if (exp.fullExpandWidth > newWidth) {
	        setTimeout("hs.cpghs_putFullExpand("+ key +")", hs.cpghs_expandDuration + hs.cpghs_fullExpandDelay);
	    }
	   
	} catch (e) {
	    if (hs.cpghs_expanders[key] && hs.cpghs_expanders[key].a) window.location.href = hs.cpghs_expanders[key].a.href;
	}
}, 

cpghs_cancelLoading : function(key) {
	var exp = hs.cpghs_expanders[key];
	exp.thumb.style.cursor = exp.originalCursor;
	// remove loading div
    if (exp.loading) {
        hs.cpghs_container.removeChild(exp.loading);
        exp.loading = null;
    }
        
    hs.cpghs_expanders[key] = null;
},

cpghs_toggleIFrames : function(visibility) { // Iframes bug
    var iframes = document.getElementsByTagName('IFRAME');
    if (iframes) {
        for (var i in iframes) {
            if (iframes[i].nodeName == 'IFRAME') iframes[i].style.visibility = visibility;
        }
    }
},

cpghs_writeCredits : function (key) {
    var exp = hs.cpghs_expanders[key];
    var credits = document.createElement('a');
    credits.href = hs.cpghs_creditsHref;
    credits.className = 'highslide-credits';
    credits.innerHTML = hs.cpghs_creditsText;
    credits.title = hs.cpghs_creditsTitle;
    credits.style.position = 'absolute';
    credits.style.zIndex = 3;
    
    if (hs.cpghs_ie) { // strange bug sometimes makes values wrong in the first def.
        exp.offsetBorderW = (exp.wrapper.offsetWidth - exp.fullImage.width) / 2;
        exp.offsetBorderH = (exp.wrapper.offsetHeight - exp.fullImage.height) / 2;
	}  
    credits.style.top = exp.offsetBorderH +'px';
    credits.style.left = exp.offsetBorderW +'px';
    exp.credits = credits;
    exp.wrapper.appendChild(credits);

},

cpghs_writeCaption : function(key) {
    var exp = hs.cpghs_expanders[key];
    
    exp.wrapper.style.width = exp.wrapper.offsetWidth +'px';    
    exp.caption.style.visibility = 'hidden';
    exp.caption.style.position = 'relative';
    if (hs.cpghs_ie) exp.caption.style.zoom = 1;  
    exp.caption.className += ' highslide-display-block'; // have to use className due to Opera
    exp.wrapper.appendChild(exp.caption);
    
    var capHeight = exp.caption.offsetHeight;
    var slideHeight = (capHeight < exp.fullImage.height) ? capHeight : exp.fullImage.height;
    exp.caption.style.marginTop = '-'+ slideHeight +'px';
    exp.caption.style.zIndex = 2;
    
    var step = 1;
    if (slideHeight > 400) step = 4;
    else if (slideHeight > 200) step = 2;
    else if (slideHeight > 100) step = 1;
    
    
    setTimeout("hs.cpghs_expanders["+ key +"].caption.style.visibility = 'visible'", 10); // flickering in Gecko
	var t = 0;
    for (cpghs_marginTop = - slideHeight; cpghs_marginTop <= 0; cpghs_marginTop += step, t += 10) {
        setTimeout ("if (hs.cpghs_expanders["+ key +"] && hs.cpghs_expanders["+ key +"].caption) "
            + "hs.cpghs_expanders["+ key +"].caption.style.marginTop = '"+ cpghs_marginTop +"px'", t);
    }
	
	setTimeout('hs.cpghs_writeOutline('+ key +')', t + 10);
    
},

cpghs_writeOutline : function(key) {
    if (!hs.cpghs_expanders[key]) return;
    var exp = hs.cpghs_expanders[key];    
    exp.outline = new Array();
    var v = hs.cpghs_ieVersion();
    
    hs.hasAlphaImageLoader = (v >= 5.5) && (v < 7) && (document.body.filters);
	hs.hasPngSupport = v >= 7 || !document.body.filters;
    
    hs.cpghs_preloadOutlineElement(key, 1); // start recursive process
}, 

cpghs_preloadOutlineElement : function(key, i) {
    if (!hs.cpghs_expanders[key]) return;
    if (!hs.hasAlphaImageLoader && !hs.hasPngSupport) return;
    
    var exp = hs.cpghs_expanders[key];
    
    if (exp.outline[i] && exp.outline[i].onload) { // Gecko multiple onloads bug
        exp.outline[i].onload = null;
        return;
    }
    
    var src = hs.cpghs_graphicsDir + "outlines/"+ exp.cpghs_outlineType +"/"+ i +".png";
    
    if (hs.hasAlphaImageLoader) {
        
		exp.outline[i] = document.createElement('div');
	 	exp.outline[i].style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader("
	     	+ "enabled=true, sizingMethod=scale src='"+ src + "') ";
	} 
        
	var img = document.createElement('img'); // for onload trigger
	if (hs.hasPngSupport) {
        exp.outline[i] = img;
    }
    
    // common properties
	exp.outline[i].style.position = 'absolute';
	var dim = (i % 2 == 1) ? '10px' : '20px';
	exp.outline[i].style.height = dim;
	exp.outline[i].style.width = dim;
    
    if (i < 8) img.onload = function() { hs.cpghs_preloadOutlineElement(key, i + 1); };                
    else img.onload = function() { hs.cpghs_displayOutline(key); };
	img.src = src;
},

cpghs_displayOutline : function(key) {
    if (!hs.cpghs_expanders[key]) return; // already closed
    var exp = hs.cpghs_expanders[key];
    
    hs.cpghs_repositionOutline(key, 12);
	for (i = 1; i <= 8; i++) {
		exp.wrapper.appendChild(exp.outline[i]);
	}
	exp.hasOutline = true;
    
    // IE6
    exp.outline[1].style.lineHeight = '10px';
    exp.outline[5].style.lineHeight = '10px';
	
	for (i = 10, t = 0; i >= 0; i--, t += 50) {
	    setTimeout("hs.cpghs_repositionOutline("+ key +", "+ i +");", t);   
	}   
},

cpghs_repositionOutline : function(key, offset) {
	if (!hs.cpghs_expanders[key]) return;
	var exp = hs.cpghs_expanders[key];
    if (exp.isClosing) {
        hs.cpghs_removeOutlines(key);
        return;
    }
    
	var w = exp.wrapper.offsetWidth;
	var h = exp.wrapper.offsetHeight;

	// top
	exp.outline[1].style.width = (w - (2 * offset) - 20) +'px';
    // strange khtml bug causes glitch in outline:
	if (navigator.vendor == 'KDE') exp.outline[1].style.height = ((offset % 2) + 10) +'px';
	exp.outline[1].style.left = (10 + offset) +'px';
	exp.outline[1].style.top = (-10 + offset) + 'px';
	
	// top-right
	exp.outline[2].style.left = (w - 10 - offset) +'px';
	exp.outline[2].style.top = (-10 + offset) + 'px';
	
	// right
	exp.outline[3].style.left = (w - offset) +'px';
	exp.outline[3].style.top = (10 + offset) +'px';
	exp.outline[3].style.height = (h - (2 * offset) - 20) +'px';
	
	// bottom-right
	exp.outline[4].style.left = (w - 10 - offset) +'px';
	exp.outline[4].style.top = (h - 10 - offset) +'px';
	
	// bottom
	exp.outline[5].style.width = (w - (2 * offset) - 20) +'px';
	if (navigator.vendor == 'KDE') exp.outline[5].style.height = ((offset % 2) + 10) +'px';
	exp.outline[5].style.left = (10 + offset) +'px';
	exp.outline[5].style.top = (h - offset) + 'px';
	
	// bottom-left
	exp.outline[6].style.left = (-10 + offset) +'px';
	exp.outline[6].style.top = (h - 10 - offset) +'px';
	
	// left
	exp.outline[7].style.left = (-10 + offset) +'px';
	exp.outline[7].style.top = (10 + offset) +'px';
	exp.outline[7].style.height = (h - (2 * offset) - 20) +'px';
	
	// top-left
	exp.outline[8].style.left = (-10 + offset) +'px';
	exp.outline[8].style.top = (-10 + offset) + 'px';
	
},
cpghs_removeOutlines : function(key) {
    try {
        var exp = hs.cpghs_expanders[key];
	    for (i = 1; i <= 8; i++) {
		    if (exp.hasOutline && exp.outline[i]) {
	            exp.wrapper.removeChild(exp.outline[i]);
	        }
	    }
    } catch (e) {}
},
//--- Focus by click
cpghs_focus : function(key) {
    var img = hs.cpghs_expanders[key].fullImage;
    // image
    for (var i in hs.cpghs_expanders) {
        if (hs.cpghs_expanders[i] && hs.cpghs_expanders[i].fullImage.className == 'highslide-image' && i != key) {
            var blurKey = i;
            hs.cpghs_expanders[i].fullImage.className += ' highslide-image-blur';
            hs.cpghs_expanders[i].fullImage.title = hs.cpghs_focusTitle;
            if (hs.cpghs_expanders[i].caption) {
                hs.cpghs_expanders[i].caption.className += ' highslide-caption-blur';
            }
        }
    }
    hs.cpghs_expanders[key].wrapper.style.zIndex = hs.cpghs_zIndexCounter++;
    img.className = 'highslide-image';
    if (hs.cpghs_expanders[key].caption) {
        hs.cpghs_expanders[key].caption.className = hs.cpghs_expanders[key].caption.className.replace(' highslide-caption-blur', '');
    }
    
    img.title = hs.cpghs_restoreTitle;
    
    hs.cpghs_isBusy = false;
},

//--- Focus the topmost image after restore
cpghs_focusTopmost : function() {
    var topZ = 0;
    var topmostKey = '';
    for (var i in hs.cpghs_expanders) {
        if (hs.cpghs_expanders[i] && hs.cpghs_expanders[i].fullImage.className.match('highslide-image-blur')) {
            if (hs.cpghs_expanders[i].wrapper.style.zIndex && hs.cpghs_expanders[i].wrapper.style.zIndex > topZ) {
                topZ = hs.cpghs_expanders[i].wrapper.style.zIndex;
                topmostKey = i;
            }
        }
    }
    //alert (topmostKey);
    if (topmostKey != '') hs.cpghs_focus(topmostKey);
    hs.cpghs_isBusy = false;
}, 

//--- Interface for text links
cpghs_closeId : function(elId) {
    for (var i in hs.cpghs_expanders) {
        if (hs.cpghs_expanders[i] && hs.cpghs_expanders[i].thumb.id == elId) {
            hs.cpghs_restoreThumb(i);
            return;
        }
    }
},

//--- Click on large image to restore thumb size
cpghs_restoreThumb : function(key) {
    if (hs.cpghs_isBusy) return;
    hs.cpghs_isBusy = true;
    try {
		var exp = hs.cpghs_expanders[key];
        exp.isClosing = true;
    
        // remove full expand icon
        if (exp.cpghs_fullExpand) {
            hs.cpghs_expanders[key].cpghs_fullExpand.parentNode.removeChild(exp.cpghs_fullExpand);
            exp.cpghs_fullExpand = null;
        }
        // remove caption div
        if (exp.caption) {
            exp.wrapper.removeChild(exp.caption);
            exp.caption = null;
        }
        // remove credits
        if (exp.credits) {
            exp.wrapper.removeChild(exp.credits);
            exp.credits = null;
        }
        hs.cpghs_removeOutlines(key);
        
		hs.outlinePreloader = 0;
        exp.wrapper.style.width = null;
        
        var width = exp.fullImage.width;
        var height = exp.fullImage.height;
        var left = parseInt(exp.wrapper.style.left);
        var top = parseInt(exp.wrapper.style.top);
	    intervalWidth = (exp.thumbWidth - width) / hs.cpghs_restoreSteps;
	    intervalHeight = (exp.thumbHeight - height) / hs.cpghs_restoreSteps;
        intervalLeft = (exp.thumbLeft + exp.thumbOffsetBorderW - exp.offsetBorderW - left) / hs.cpghs_restoreSteps;
        intervalTop = (exp.thumbTop + exp.thumbOffsetBorderH - exp.offsetBorderH - top) / hs.cpghs_restoreSteps;
        
        var oldRight = Math.round(left + width);
        var oldBottom = Math.round(top + height);        
	    
        for (i = 1; i < hs.cpghs_restoreSteps; i++) {
		    width += intervalWidth;
		    height += intervalHeight;
            left += intervalLeft;
            top += intervalTop;
            
		    setTimeout("hs.cpghs_changeSize("+ key +", "+ width +", "+ height +", "+ left +", "+ top +")", 
                Math.round(i * (hs.cpghs_restoreDuration / hs.cpghs_restoreSteps)));
	    }
        setTimeout('hs.cpghs_endRestore('+ key +')', hs.cpghs_restoreDuration);
    
    } catch (e) {
        hs.cpghs_expanders[key].thumb.style.visibility = 'visible';
        hs.cpghs_expanders[key].wrapper.parentNode.removeChild(hs.cpghs_expanders[key].wrapper);
    }
},

cpghs_endRestore : function (key) {
    var exp = hs.cpghs_expanders[key];
    exp.thumb.style.visibility = 'visible';
    exp.fullImage.style.visibility = 'hidden';
    if (hs.hideIframes) {
        var remaining = -1;
        for (var i in hs.cpghs_expanders) {
            if (hs.cpghs_expanders[i]) remaining++;
        }
        if (remaining <= 0) hs.cpghs_toggleIFrames('visible');
    }
    
    exp.wrapper.parentNode.removeChild(exp.wrapper);
    
    hs.cpghs_expanders[key] = null;
    
    
    if (hs.toggleImagesExpandEl) { // see below
        hs.cpghs_expand(hs.toggleImagesExpandEl, hs.toggleImagesParams);
        hs.toggleImagesExpandEl = null;
        hs.toggleImagesParams = null;
    } else {
        hs.cpghs_focusTopmost();
    }
},

//--- Function for next and previous links
cpghs_toggleImages : function(closeId, expandEl, params) {
    hs.cpghs_closeId(closeId);
    if (hs.cpghs_ie) expandEl.href = expandEl.href.replace('about:blank', ''); // mysterious IE thing
    hs.toggleImagesExpandEl = expandEl;
    hs.toggleImagesParams = params;
    return false;
},


//--- Do the stepwise change
cpghs_changeSize : function (key, newWidth, newHeight, newLeft, newTop) {
    try {
        var exp = hs.cpghs_expanders[key];
    
        exp.fullImage.width = newWidth;
        exp.fullImage.height = newHeight;
        exp.wrapper.style.visibility = 'visible';
        exp.wrapper.style.left = newLeft +'px';
        exp.wrapper.style.top = newTop +'px';
        exp.fullImage.style.visibility = 'visible';
        exp.thumb.style.visibility = 'hidden';
        
    } catch (e) {
        window.location.href = hs.cpghs_expanders[key].a.href;
    }
},

//--- Icon for full expand 
cpghs_putFullExpand : function (key) {
    if (hs.cpghs_isBusy) return;
    
    if (!hs.cpghs_expanders[key]) {
        return;
    }
    
    var href = hs.cpghs_expanders[key].fullImage.src;
    var thisKey = key;
    
    // the anchor
    
    var aFullExpand = document.createElement('a');
    aFullExpand.id = 'fullexpand-'+ hs.cpghs_expanders[key].fullImage.id;
    aFullExpand.style.position = 'absolute';
    aFullExpand.style.left = (hs.cpghs_expanders[key].fullImage.width - 55) +'px';
    aFullExpand.style.top = (hs.cpghs_expanders[key].fullImage.height - 55) +'px';
    aFullExpand.style.zIndex = 3;
    aFullExpand.href = 'javascript:hs.cpghs_fullExpand('+ key +');';
    aFullExpand.title = hs.cpghs_fullExpandTitle;
    aFullExpand.onmouseover = function () { hs.cpghs_mouseIsOverFullExpand = true; }
    aFullExpand.onmouseout = function () { hs.cpghs_mouseIsOverFullExpand = false; }
    
    // the image
    var imgFullExpand = document.createElement('img');
    imgFullExpand.src = hs.cpghs_graphicsDir + hs.cpghs_fullExpandIcon;
    imgFullExpand.style.border = '0';
    imgFullExpand.style.display = 'block';
    aFullExpand.appendChild(imgFullExpand);
    
    hs.cpghs_expanders[key].wrapper.appendChild(aFullExpand);
    hs.cpghs_expanders[key].cpghs_fullExpand = aFullExpand;
},

cpghs_fullExpand : function (key) {
    try {
        var exp = hs.cpghs_expanders[key];
        
        var newLeft = parseInt(exp.wrapper.style.left) - (exp.fullExpandWidth - exp.fullImage.width) / 2;
        if (newLeft < hs.cpghs_marginLeft) newLeft = hs.cpghs_marginLeft;
        exp.wrapper.style.left = newLeft +'px';
		
		var borderOffset = exp.wrapper.offsetWidth - exp.fullImage.width;
        
        exp.fullImage.width = exp.fullExpandWidth;
        exp.fullImage.height = exp.fullExpandHeight;
        hs.cpghs_focus(key);
        
        exp.cpghs_fullExpand.className = 'highslide-display-none';
        
        hs.cpghs_mouseIsOverFullExpand = false;
        
        exp.wrapper.style.width = (exp.fullImage.width + borderOffset) +'px';
        
        if (hs.cpghs_outlineType) hs.cpghs_repositionOutline(key, 0);
    
    } catch (e) {
        window.location.href = hs.cpghs_expanders[key].fullImage.src;
    }
},

cpghs_showFullExpand : function (key) {
    if (hs.cpghs_expanders[key] && hs.cpghs_expanders[key].cpghs_fullExpand) {
        hs.cpghs_expanders[key].cpghs_fullExpand.style.visibility = 'visible';
    }
},

cpghs_hideFullExpand : function(key) {
    if (hs.cpghs_expanders[key] && hs.cpghs_expanders[key].cpghs_fullExpand && !hs.cpghs_mouseIsOverFullExpand) {
        hs.cpghs_expanders[key].cpghs_fullExpand.style.visibility = 'hidden';
    }
},

//--- Preload a number of images recursively
cpghs_preloadFullImage : function (i) {
    if (hs.cpghs_continuePreloading && hs.cpghs_preloadTheseImages[i] && hs.cpghs_preloadTheseImages[i] != 'undefined') {
        var img = document.createElement('img');
        img.onload = function() { hs.cpghs_preloadFullImage(i + 1); }
        img.src = hs.cpghs_preloadTheseImages[i];
    }
},

cpghs_mouseMoveHandler : function(e)
{
  if (hs.cpghs_isDrag)
  {
    var key = hs.cpghs_dragObj.getAttribute('key');
    if (!hs.cpghs_expanders[key].wrapper) return;
    var wrapper = hs.cpghs_expanders[key].wrapper;
    
    var left = hs.cpghs_nn6 ? tx + e.clientX - hs.cpghs_dragX : tx + event.clientX - hs.cpghs_dragX;
    wrapper.style.left = left +'px';
    var top = hs.cpghs_nn6 ? ty + e.clientY - hs.cpghs_dragY : ty + event.clientY - hs.cpghs_dragY;
    wrapper.style.top  = top +'px';
    
    return false;
  }
}, 

cpghs_mouseDownHandler : function(e) 
{

  var fobj       = hs.cpghs_nn6 ? e.target : event.srcElement;
  var topelement = hs.cpghs_nn6 ? "HTML" : "BODY";
  
  while (fobj.tagName != topelement && fobj.tagName != 'HTML' && !fobj.className.match('highslide-image'))
  {
    fobj = hs.cpghs_nn6 ? fobj.parentNode : fobj.parentElement;
  }
  if (fobj.className.match('highslide-image'))
  {
    hs.cpghs_isDrag = true;
    hs.cpghs_dragObj = fobj;
    var tmpCursor = hs.cpghs_dragObj.style.cursor;
    hs.cpghs_defaultRestoreCursor = tmpCursor;
    hs.cpghs_dragObj.style.cursor = 'move';
    tx = parseInt(hs.cpghs_dragObj.parentNode.style.left);
    ty = parseInt(hs.cpghs_dragObj.parentNode.style.top);
    
    hs.cpghs_leftBeforeDrag = tx;
    hs.cpghs_topBeforeDrag = ty;
    
    hs.cpghs_dragX = hs.cpghs_nn6 ? e.clientX : event.clientX;
    hs.cpghs_dragY = hs.cpghs_nn6 ? e.clientY : event.clientY;
    document.onmousemove = hs.cpghs_mouseMoveHandler;
    
    if (fobj.className.match('highslide-image-blur')) {
        hs.cpghs_focus(fobj.getAttribute('key'));
        hs.cpghs_hasFocused = true;
    }
    return false;
  }
},

cpghs_mouseUpHandler : function(e) {
    hs.cpghs_isDrag = false;
    var fobj       = hs.cpghs_nn6 ? e.target : event.srcElement;
    var topelement = hs.cpghs_nn6 ? "HTML" : "BODY";

    while (fobj.tagName != topelement && fobj.tagName != 'HTML' && !fobj.className.match('highslide-image'))
    {
        fobj = hs.cpghs_nn6 ? fobj.parentNode : fobj.parentElement;
    }
    if (fobj.className == 'highslide-image') {
        fobj.style.cursor = hs.cpghs_defaultRestoreCursor;
        //if (hasDragged) hasDragged = false;
        var left = parseInt(fobj.parentNode.style.left);
        var top = parseInt(fobj.parentNode.style.top);
        if (left == hs.cpghs_leftBeforeDrag && top == hs.cpghs_topBeforeDrag && !hs.cpghs_hasFocused) {
            hs.cpghs_restoreThumb(fobj.getAttribute('key'));
        }
        hs.cpghs_hasFocused = false;
    
    } else if (fobj.className.match('highslide-image-blur')) {
        fobj.style.cursor = hs.cpghs_defaultRestoreCursor;
        
    }
},

cpghs_preloadImages : function () {
    
    var j = 0;
    
    var aTags = document.getElementsByTagName('A');
    for (var i in aTags) {
        a = aTags[i];
        if (a.className && (a.className.match("highslide$") || a.className.match("highslide "))) {
            if (j < this.cpghs_numberOfImagesToPreload) {
                hs.cpghs_preloadTheseImages[j] = a.href;
                j++;
            }
        }
    }
    
    hs.cpghs_preloadFullImage(0); // starts recursive process
    
    // preload cursor
    var cur = document.createElement('img');
    cur.src = hs.cpghs_graphicsDir + hs.cpghs_restoreCursor;
    
    // preload outlines
    for (i = 1; i <= 8; i++) {
        var img = document.createElement('img');
        img.src = hs.cpghs_graphicsDir + "outlines/"+ hs.cpghs_outlineType +"/"+ i +".png";
    }
    
}
} // end hs object

// set handlers
document.onmousedown = hs.cpghs_mouseDownHandler;
document.onmouseup = hs.cpghs_mouseUpHandler;