<?php

require('include/init.inc.php');

pageheader("Filetype editor");

if (!GALLERY_ADMIN_MODE) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);


$player_types = array('' => 'No player',
										'WMP' => 'Windows media player',
										'SWF' => 'Flash player',
										'QT' => 'Apple QuickTime',
										'RMP' => 'RealMedia player'
										);
										
if (isset($_POST['update']) || isset($_GET['ext'])){

if (isset($_GET['ext'])){
	$filedata = $FILE_TYPES[$_GET['ext']];
	$add_update = 'Update';
} else {
	$filedata = false;
	$add_update = 'Add';
}

echo '<form action="index.php?file=filetypes_editor/editor" method="post" name="updateform">';

$content_dropdown = '<select name="file[content]" class="listbox">';

$content_types = array('image', 'movie', 'audio', 'document');

foreach ($content_types as $content_type){
	$selected = ($filedata && $content_type == $filedata['content']) ? 'selected="selected"' : '';
	$content_dropdown .= "<option value=\"$content_type\" $selected>". ucfirst($content_type) . '</option>';
}

$content_dropdown .= '</select>';

$player_dropdown = '<select name="file[player]" class="listbox">';

foreach ($player_types as $type => $label){
	$selected = ($filedata && $type == $filedata['player']) ? 'selected="selected"' : '';
	$player_dropdown .=  "<option value=\"$type\" $selected>". $label . '</option>';
}

$player_dropdown .= '</select>';

$presel_extension = $filedata ? $filedata['extension'] : '';
$presel_mime = $filedata ? $filedata['mime'] : '';

starttable("50%", "Enter filetype details", 2);

echo <<< EOT

	<tr>
		<td class="tableb" width="60%">
			File extension (lower case, no dot):
		</td>
		<td class="tableb" valign="top" width="40%">
			<input class="textinput" maxlength="7" size="4" name="file[extension]" type="text" value="$presel_extension"/>
		</td>
	</tr>
	
	<tr>
		<td class="tableb" width="60%">
			MIME type (must be valid):
		</td>
		<td class="tableb" valign="top" width="40%">
			<input class="textinput" maxlength="30" name="file[mime]" type="text" value="$presel_mime"/>
		</td>
	</tr>
	
	<tr>
		<td class="tableb" width="60%">
			Content type
		</td>
		<td class="tableb" valign="top" width="40%">
			$content_dropdown
		</td>
	</tr>

	<tr>
		<td class="tableb" width="60%">
			Associated Player
		</td>
		<td class="tableb" valign="top" width="40%">
			$player_dropdown
		</td>
	</tr>
	
<tr>
	<td colspan="2" align="center" class="tablef">
		<input type="submit" name="addit" value="$add_update" class="button" />
	</td>
</tr>

EOT;

endtable();
echo '</form>';
pagefooter();
die();

} elseif (isset($_POST['addit'])){
	
	$filedata = array_map('mysql_real_escape_string', $_POST['file']);

	$ops = array();
	
	foreach ($filedata as $name => $value){
		$ops[] = "`$name` = '$value'";
	}
	
	$newdata = implode(', ', $ops);
	
	cpg_db_query("REPLACE INTO {$CONFIG['TABLE_FILETYPES']} SET $newdata");
	
} elseif (isset($_POST['delete'])){
	
	$extensions = array();
	
	foreach($_POST['cid_array'] as $extension){
		$extensions[] = "`extension` = '" . mysql_real_escape_string($extension) . "'";
	}
	
	$extquery = implode(' OR ', $extensions);
	
	cpg_db_query("DELETE FROM {$CONFIG['TABLE_FILETYPES']} WHERE $extquery");
		
}

?>
              <script type="text/javascript" language="javascript">
<!--

function selectAll(d,box) {
  var f = document.editForm;
  for (i = 0; i < f.length; i++) {
    //alert (f[i].name.indexOf(box));
    if (f[i].type == "checkbox" && f[i].name.indexOf(box) >= 0) {
      if (d.checked) {
        f[i].checked = true;
      } else {
        f[i].checked = false;
      }
    }
  }
  if (d.name == "checkAll") {
      document.getElementsByName('checkAll2')[0].checked = document.getElementsByName('checkAll')[0].checked;
  } else {
      document.getElementsByName('checkAll')[0].checked = document.getElementsByName('checkAll2')[0].checked;
  }
}

-->
</script>
<form action="index.php?file=filetypes_editor/editor" method="post" name="editForm">
<?php
starttable("70%", "", 6);

?>
        <tr>
			<td class="tableh1" valign="middle" align="center">
				<input type="checkbox" name="checkAll" onClick="selectAll(this,'cid_array');" class="checkbox" title="check/uncheck all" />
			</td>
			<td class="tableh1"><span class="statlink">Extension</span></td>
			<td class="tableh1"><span class="statlink">MIME type</span></td>
			<td class="tableh1"><span class="statlink">Content type</span></td>
			<td class="tableh1"><span class="statlink">Associated player</span></td>
			<td class="tableh1">Edit</td>
        </tr>
<?php

$result = cpg_db_query("SELECT * FROM {$CONFIG['TABLE_FILETYPES']} ORDER BY extension ASC");

$i = 0;

while (++$i && $row = cpg_db_fetch_row($result)){
	
	$player = $player_types[$row['player']];
	
	echo  <<< EOT

<tr>
	<td class="tableb" valign="top" align="center">
		<input name="cid_array[]" id="check{$i}" type="checkbox" value="{$row['extension']}" />
	</td>
	<td class="tableb">{$row['extension']}</td>
	<td class="tableb">{$row['mime']}</td>
	<td class="tableb">{$row['content']}</td>
	<td class="tableb">$player</td>
	<td class="tableb"><a href="index.php?file=filetypes_editor/editor&ext={$row['extension']}"><img src="images/edit.gif" align="middle" border="0"></a></td>
</tr>

EOT;

}

echo <<< EOT

<tr>
	<td colspan="6" align="center" class="tablef">
		<input type="submit" name="delete" value="Delete selected filetypes" class="button" />
		<input type="submit" name="update" value="Add a new filetype" class="button" />
	</td>
</tr>

EOT;

endtable();
echo '</form>';
pagefooter();
?>